//
//  OPMap.m
//  The Obfuscated Path
//
//  Created by ss2cire on 12/8/08.
//  Copyright 2008 GryphonClaw Software. All rights reserved.
//

#import "OPMap.h"
#import "OPRoom.h"
#import "OPSprite.h"
#import "OPRoomLayer.h"
#import "OPTrigger.h"

NSArray* GetRoomTriggers(int roomX, int roomY, NSDictionary *triggersByRoom);

@implementation OPMap
- (id)initWithMap:(NSString *)mapName
{
	self = [super init];
	if(self != nil) {
		name = [mapName retain];
		rooms = [[NSMutableArray alloc] init];
		currentRoom = nil;
		previousRoom = nil;
		currentRoomPoint = NSZeroPoint;
		
		[self loadMapFile:[self pathToMap]];// withEvents:eventList];
	}
	return self;
}

- (NSString *)pathToMap
{
	NSString *pathToMap = [[NSBundle mainBundle] resourcePath];
	return [NSString stringWithFormat:@"%@/Maps/%@.topmap", pathToMap, name];
}

- (NSString *)getMapResource:(NSString *)resourceName
{
	return  [[self pathToMap] stringByAppendingPathComponent:resourceName];
}

- (void)dealloc
{
	[super dealloc];
}

- (void)loadMapFile:(NSString *)path// withEvents:(NSDictionary *)events
{
	NSString *mapLayoutFilePath = [self getMapResource:@"Layout.txt"];
	NSString *eventDataFile = [self getMapResource:@"Triggers.plist"];
	NSString *enemyDataFilePath = [self getMapResource:@"Enemies.plist"];

	NSDictionary *eventList = [NSDictionary dictionaryWithContentsOfFile:eventDataFile];
	NSDictionary *enemyDataFile = [NSDictionary dictionaryWithContentsOfFile:enemyDataFilePath];

	OPRoom *theRoom;
	NSString *mapLayoutFile = [NSString stringWithContentsOfFile:mapLayoutFilePath];
	NSArray *lines = [mapLayoutFile componentsSeparatedByString:@"\n"];
	NSEnumerator *enumerator = [lines reverseObjectEnumerator];
	id line = nil;
	int roomX = 0, roomY = 0;

	while((line = [enumerator nextObject]) != nil) {
		roomX = 0;
		NSArray *cells = [line componentsSeparatedByString:@","];
		NSMutableArray *roomRow = [[NSMutableArray alloc] init];
		NSEnumerator *cellEnumerator = [cells objectEnumerator];
		id cellData = nil;
		while((cellData = [cellEnumerator nextObject]) != nil) {
			NSString *fileName = cellData;
			if(![fileName isEqualToString:@"00"]) {
				NSString *roomDataName = [NSString stringWithFormat:@"Rooms/%@.txt", fileName];
				NSString *roomDataFilePath = [path stringByAppendingPathComponent:roomDataName];
				theRoom = [[[OPRoom alloc] initWithRoomData:roomDataFilePath] autorelease];

				//break into another function?
				NSArray *roomEvents = GetRoomTriggers(roomX, roomY, eventList);
				if(roomEvents != nil) {
					NSEnumerator *eventListEnumerator = [roomEvents objectEnumerator];
					NSString *triggerDescriptionFileName = nil;
					while((triggerDescriptionFileName = [eventListEnumerator nextObject]) != nil) {
						NSString *relativePathToEvenDescriptionFile = [NSString stringWithFormat:@"Triggers/%@.plist", triggerDescriptionFileName];
						NSString *eventDescriptionFile = [[self pathToMap] stringByAppendingPathComponent:relativePathToEvenDescriptionFile];
						NSDictionary *roomTriggerDescription = [NSDictionary dictionaryWithContentsOfFile:eventDescriptionFile];
						[theRoom loadEventData:roomTriggerDescription withName:triggerDescriptionFileName];
					}
				}
				NSArray *enemyList = GetRoomTriggers(roomX, roomY, enemyDataFile);
				if(enemyList != nil) {
					[theRoom loadEnemyList:enemyList];
				}
				[roomRow addObject:theRoom];
				
			} else {
				[roomRow addObject:[NSNull null]];
			}
			roomX++;
		}
		[rooms addObject:roomRow];
		roomY++;
	}
	currentRoom = nil;
}

- (void)draw
{
	[currentRoom draw];
	if(scrolling) {
		[previousRoom draw];
	}
}

- (void)update
{
	
	if(scrolling) {
		[self scroll];
	} else {
		[currentRoom update];
	}
}

- (void)scroll
{
	switch(scrollingDirection) 
	{
		case OPUp:
			[currentRoom scrollYBy:-4];
			[previousRoom scrollYBy:-4];
			if([currentRoom yOffset] == 0) {
				scrolling = NO;
				[[currentRoom player] setLocationY:0];
			}
			break;
		case OPDown:
			[currentRoom scrollYBy:4];
			[previousRoom scrollYBy:4];
			if([currentRoom yOffset] == 0) {
				scrolling = NO;
				[[currentRoom player] setLocationY:(32 * 11) - 32];
			}
			break;
		case OPRight:
			[currentRoom scrollXBy:-4];
			[previousRoom scrollXBy:-4];
			if([currentRoom xOffset] == 0) {
				scrolling = NO;
				[[currentRoom player] setLocationX:0];
			}
			break;
		case OPLeft:
			[currentRoom scrollXBy:4];
			[previousRoom scrollXBy:4];
			if([currentRoom xOffset] == 0) {
				scrolling = NO;
				[[currentRoom player] setLocationX:(32 * 16) - 32];
			}
			break;
	}
	//The rooms are no longer scrolling, so tell the current room we've entered it.
	if(!scrolling) {
		[self enteredRoom];
	}
}

- (void)setScrolling:(BOOL)value direction:(OPDirection)direction
{
	scrolling = value;
	if(scrolling) {
		previousRoom = currentRoom;
		[self exitedRoom];
		scrollingDirection = direction;
		switch(direction) {
			case OPRight:
				[self setCurrentRoomAtX:currentRoomPoint.x + 1 andY:currentRoomPoint.y];
				[currentRoom scrollXBy:(32 * 16)];
				break;
			case OPLeft:
				[self setCurrentRoomAtX:currentRoomPoint.x - 1 andY:currentRoomPoint.y];
				[currentRoom scrollXBy:-(32 * 16)];
				break;
			case OPUp:
				[self setCurrentRoomAtX:currentRoomPoint.x andY:currentRoomPoint.y + 1];
				[currentRoom scrollYBy:(32 * 11)];
				break;
			case  OPDown:
				[self setCurrentRoomAtX:currentRoomPoint.x andY:currentRoomPoint.y - 1];
				[currentRoom scrollYBy:-(32 * 11)];
				break;
		}
	}
}

- (BOOL)scrolling
{
	return scrolling;
}

- (void)setCurrentRoomAtX:(int)x andY:(int)y
{
	int cols = [[rooms objectAtIndex:y] count];
	int rows = [rooms count];
	if((x >= 0 && x < cols) && (y >= 0 && y < rows)) {
		
		currentRoomPoint.x = x;
		currentRoomPoint.y = y;
		id roomRow = [rooms objectAtIndex:(int)currentRoomPoint.y];
		id room = [roomRow objectAtIndex:(int)currentRoomPoint.x];
		if(room != [NSNull null]) {
			currentRoom = room;
		} else {
			currentRoom = nil;
		}

		[currentRoom resetScroll];
	} else {
		NSLog(@"x [%i] or y[%i] not in the bounds of the map.", x, y);
		currentRoom = nil;
		previousRoom = nil;
	}

	[currentRoom setCurrent];
}

- (OPSprite *)tileAtX:(int)x andY:(int)y
{
	return [self tileAtX:x Y:y andLayer:OPlayerObjects];
}
- (OPSprite *)tileAtX:(int)x Y:(int)y andLayer:(OPLayer)layer
{
	OPRoomLayer *theLayer = [currentRoom layer:layer];
	return [theLayer tileAtX:x andY:y];
}

- (OPRoom *)currentRoom
{
	return currentRoom;
}

- (NSArray *)triggers
{
	return [currentRoom triggers];
}

- (NSString *)name
{
	return name;
}

- (NSString *)description
{
	return [NSString stringWithFormat:@"%@ %@", name, self];
}

- (void)enteredRoom
{
	[currentRoom entered];
}

- (void)exitedRoom
{
	[currentRoom exited];
}
@end

NSArray* GetRoomTriggers(int roomX, int roomY, NSDictionary *triggersByRoom)
{
	NSArray *roomTriggerList = nil;
	NSEnumerator *enumerator = [triggersByRoom keyEnumerator];
	id triggerKey = nil;
	while((triggerKey = [enumerator nextObject]) != nil) {
		NSPoint thePoint = NSPointFromString(triggerKey);
		if((roomX == (int)thePoint.x) && (roomY == (int)thePoint.y)) {
			roomTriggerList = [triggersByRoom objectForKey:triggerKey];
			break;
		}
	}
	return roomTriggerList;
}
